# Install-RustDesk.ps1
# Mackey Systemhaus – RustDesk Client Setup (vordefinierter ID/Relay/Key)
# Rechtsklick -> "Mit PowerShell ausführen"
# Falls Windows blockt: PowerShell öffnen und:
#   Set-ExecutionPolicy -Scope Process -ExecutionPolicy Bypass -Force

[CmdletBinding()]
param(
  [string]$Version   = "1.4.4",
  [string]$IdServer  = "rust.it-nb.de:21116",
  [string]$Relay     = "rust.it-nb.de:21117",
  [string]$Key       = "13g0W2t0PuTylN8C8fcWW6QVtLnVil9FxWpHaGkquCk=",
  [string]$ApiServer = "https://rust.it-nb.de",
  [switch]$StartNow
)

$ErrorActionPreference = "Stop"

function Write-Info($msg){ Write-Host "[INFO] $msg" -ForegroundColor Cyan }
function Write-Ok($msg){ Write-Host "[OK]   $msg" -ForegroundColor Green }
function Write-Warn($msg){ Write-Host "[WARN] $msg" -ForegroundColor Yellow }

$tmp = Join-Path $env:TEMP "rustdesk-client"
New-Item -ItemType Directory -Force -Path $tmp | Out-Null

$arch = if ([Environment]::Is64BitOperatingSystem) { "x86_64" } else { "x86_32" }
$exeName = "rustdesk-$Version-$arch.exe"
$downloadUrl = "https://github.com/rustdesk/rustdesk/releases/download/$Version/$exeName"
$exePath = Join-Path $tmp $exeName

Write-Info "Lade RustDesk $Version ($arch) ..."
Invoke-WebRequest -Uri $downloadUrl -OutFile $exePath -UseBasicParsing
Write-Ok "Download: $exePath"

$installDir = Join-Path $env:ProgramFiles "RustDesk"
New-Item -ItemType Directory -Force -Path $installDir | Out-Null
$targetExe = Join-Path $installDir "RustDesk.exe"
Copy-Item -Force $exePath $targetExe
Write-Ok "RustDesk.exe nach $targetExe kopiert"

Get-Process -Name "RustDesk" -ErrorAction SilentlyContinue | Stop-Process -Force -ErrorAction SilentlyContinue

$configText = @"
rendezvous_server = '$IdServer'
nat_type = 1
serial = 0

[options]
custom-rendezvous-server = '$IdServer'
relay-server = '$Relay'
api-server = '$ApiServer'
key = '$Key'
"@

# Current user config
$userConfigDir  = Join-Path $env:APPDATA "RustDesk\config"
New-Item -ItemType Directory -Force -Path $userConfigDir | Out-Null
Set-Content -Path (Join-Path $userConfigDir "RustDesk2.toml") -Value $configText -Encoding UTF8
Set-Content -Path (Join-Path $userConfigDir "RustDesk_local.toml") -Value $configText -Encoding UTF8
Write-Ok "User-Config geschrieben: $userConfigDir"

# LocalService config (optional)
$svcBase = "C:\Windows\ServiceProfiles\LocalService\AppData\Roaming\RustDesk\config"
try {
  New-Item -ItemType Directory -Force -Path $svcBase | Out-Null
  Set-Content -Path (Join-Path $svcBase "RustDesk2.toml") -Value $configText -Encoding UTF8
  Set-Content -Path (Join-Path $svcBase "RustDesk_local.toml") -Value $configText -Encoding UTF8
  Write-Ok "Service-Config geschrieben: $svcBase"
} catch {
  Write-Warn "Konnte Service-Config nicht schreiben (kein Admin?). Ist optional."
}

# Desktop shortcut
try {
  $desktop = [Environment]::GetFolderPath("Desktop")
  $lnkPath = Join-Path $desktop "RustDesk (Mackey Support).lnk"
  $wsh = New-Object -ComObject WScript.Shell
  $lnk = $wsh.CreateShortcut($lnkPath)
  $lnk.TargetPath = $targetExe
  $lnk.WorkingDirectory = $installDir
  $lnk.IconLocation = "$targetExe,0"
  $lnk.Save()
  Write-Ok "Desktop-Link erstellt: $lnkPath"
} catch { }

Write-Host ""
Write-Host "Server-Config-String (zum manuellen Einfügen, falls nötig):"
Write-Host ("id={0};relay={1};key={2}" -f $IdServer,$Relay,$Key)
Write-Host ""
Write-Host "Prüfen: RustDesk -> Einstellungen -> Netzwerk -> ID/Relay-Server"
Write-Host "Dort sollten ID-Server / Relay-Server / Key bereits gesetzt sein."
Write-Host ""

if ($StartNow) {
  Start-Process -FilePath $targetExe | Out-Null
}
